/******************************************************************************
* This Program is the Confidential and Proprietary product of Altera Corp.    *
* Any unauthorized use,  reproduction or transfer of this program is strictly *
* prohibited. Copyright (c)  1993  by Altera Corp. All Rights Reserved.       *
*******************************************************************************/
/*

LIBRARY        : alteralib; Rev 1.0; February 93
FUNCTION       : 4 BIT BIDIRECTIONAL UNIVERSAL SHIFT REGISTER
TRUTHTABLE     : 
------------------------------------------------------------------
   CLR_  S1  S0   CLK   SL    SR     A  B  C  D     QA  QB  QC  QD  
------------------------------------------------------------------
    L    X   X     X    X     X      X  X  X  X     L   L   L   L 

    H    X   X     L    X     X      X  X  X  X     QA  QB  QC  QD 
                    _
    H    H   H    _/    X     X      A  B  C  D     A   B   C   D  
                    _
    H    L   H    _/    X     H      X  X  X  X     H   QA  QB  QC
                    _
    H    L   H    _/    X     L      X  X  X  X     L   QA  QB  QC
                    _
    H    H   L    _/    H     X      X  X  X  X     QB  QC  QD  H
                    _
    H    H   L    _/    L     X      X  X  X  X     QB  QC  QD  L

    H    L   L     X    X     X      X  X  X  X     QA  QB  QC  QD 
------------------------------------------------------------------

REFERENCE      : Altera MAX+Plus II online help, component description
DESIGNER       : AMI VIDER
DATE GENERATED : February 1993
DATE MODIFIED  : August 1993

VERITOOL COMPATIBILITY : Verilog x.x, Veritime y.y

*/
`celldefine

`timescale  1ns /  100ps
module a194 (clrn, srser, a, b, c, d, slser, s0, s1, clk, qd, qc, qb, qa);
	parameter size =1;
	input
		clrn,
		srser,
		a,
		b,
		c,
		d,
		slser,
		s0,
		s1,
		clk;
	output
		qd,
		qc,
		qb,
		qa;
    reg
        NOTIFY_REG;
    or
	  (s_active, s0, s1);
    not
	  (ns0, s0);
    not
	  (ns1, s1);
    and
	  (parallel_load, clrn, s0, s1);
    and
	  (enable_sr, clrn, s0, ns1);
    and
	  (enable_sl, clrn, ns0, s1);
    and
	  (clk_active, clrn, s_active);
    buf
	  (qa, m194_inst_qaint);
    buf
	  (qb, m194_inst_qbint);
    buf
	  (qc, m194_inst_qcint);
    buf
	  (qd, m194_inst_qdint);
    U_MUX_4_2
	M194_inst_MUX1_M5 (m194_inst_wr1, m194_inst_qaint, m194_inst_qbint, srser, a, s1, s0);
    U_MUX_4_2
	M194_inst_MUX2_M5 (m194_inst_wr2, m194_inst_qbint, m194_inst_qcint, m194_inst_qaint, b, s1, s0);
    U_MUX_4_2
	M194_inst_MUX3_M5 (m194_inst_wr3, m194_inst_qcint, m194_inst_qdint, m194_inst_qbint, c, s1, s0);
    U_MUX_4_2
	M194_inst_MUX4_M5 (m194_inst_wr4, m194_inst_qdint, slser, m194_inst_qcint, d, s1, s0);
    U_FD_P_RB_NO  
	M194_inst_FFD1_inst1 (m194_inst_qaint, m194_inst_wr1, clk, dd_net_20, NOTIFY_REG);
    U_FD_P_RB_NO  
	M194_inst_FFD2_inst1 (m194_inst_qbint, m194_inst_wr2, clk, dd_net_20, NOTIFY_REG);
    U_FD_P_RB_NO  
	M194_inst_FFD3_inst1 (m194_inst_qcint, m194_inst_wr3, clk, dd_net_20, NOTIFY_REG);
    U_FD_P_RB_NO  
	M194_inst_FFD4_inst1 (m194_inst_qdint, m194_inst_wr4, clk, dd_net_20, NOTIFY_REG);
    buf  
	  (dd_net_20, clrn);

    specify

	// Synthesis parameters

`ifdef SYNTH
	specparam Area = 1;
`endif



    endspecify

endmodule
`endcelldefine
